"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsService = void 0;
const client_1 = require("@prisma/client");
class ProductsService {
    constructor() {
        this.prisma = new client_1.PrismaClient();
    }
    async getAllProducts() {
        return this.prisma.product.findMany();
    }
    async getProductById(id) {
        return this.prisma.product.findUnique({
            where: { id },
        });
    }
    async createProduct(data) {
        return this.prisma.product.create({ data });
    }
}
exports.ProductsService = ProductsService;
exports.default = new ProductsService();
// curl -X POST http://localhost:3333/api/products \
//   -H "Content-Type: application/json" \
//   -d '{
//     "name": "Sample Product",
//     "description": "A test product",
//     "size": 10.5,
//     "units": "kg",
//     "cost": 25.99,
//     "active": true
//   }'
//# sourceMappingURL=products.service.js.map