// import { Router, Request, Response } from 'express'
// import { auth } from '../lib/auth'
export {};
// const router = Router()
// router.post('/sign-in/email', async (req: Request, res: Response) => {
//   try {
//     const { email, password } = req.body
//     // Validate input
//     if (!email || !password) {
//       return res.status(400).json({
//         success: false,
//         error: 'Email and password are required',
//       })
//     }
//     const data = await auth.api.signInEmail({
//       body: {
//         email,
//         password,
//       },
//     })
//     // Return well-structured response
//     return res.status(200).json({
//       ...data,
//       success: true,
//       message: 'Successfully signed in',
//     })
//   } catch (error) {
//     console.error('Login error:', error)
//     return res.status(401).json({
//       success: false,
//       error: error instanceof Error ? error.message : 'Authentication failed',
//     })
//   }
// })
// router.post('/register', async (req: Request, res: Response) => {
//   try {
//     const { name, email, password } = req.body
//     // Validate input
//     if (!name || !email || !password) {
//       return res.status(400).json({
//         success: false,
//         error: 'Name, email, and password are all required',
//       })
//     }
//     // Validate password strength if needed
//     if (password.length < 8) {
//       return res.status(400).json({
//         success: false,
//         error: 'Password must be at least 8 characters long',
//       })
//     }
//     const data = await auth.api.signUpEmail({
//       body: {
//         name,
//         email,
//         password,
//       },
//     })
//     // Return well-structured response
//     return res.status(201).json({
//       ...data,
//       success: true,
//       message: 'User successfully registered',
//     })
//   } catch (error) {
//     console.error('Registration error:', error)
//     // Check for duplicate email error (exact check depends on your auth implementation)
//     const errorMessage = error instanceof Error ? error.message : 'Registration failed'
//     const statusCode = errorMessage.includes('already exists') ? 409 : 400
//     return res.status(statusCode).json({
//       success: false,
//       error: errorMessage,
//     })
//   }
// })
// router.post('/sign-out', async (req: Request, res: Response) => {
//   try {
//     console.log('Sign-out request received with cookies:', req.headers.cookie)
//     console.log('All headers:', JSON.stringify(req.headers, null, 2))
//     // Get all cookies from the request
//     const cookieHeader = req.headers.cookie
//     // Build simplified headers with the essential information
//     const headers: Record<string, string> = {
//       cookie: typeof cookieHeader === 'string' ? cookieHeader : '',
//       host: typeof req.headers.host === 'string' ? req.headers.host : '',
//       origin: typeof req.headers.origin === 'string' ? req.headers.origin : '',
//       referer: typeof req.headers.referer === 'string' ? req.headers.referer : '',
//     }
//     // If there's an authorization header, include it
//     if (req.headers.authorization) {
//       headers['authorization'] = typeof req.headers.authorization === 'string' ? req.headers.authorization : ''
//     }
//     try {
//       // Make sure we pass headers but don't send a body
//       await auth.api.signOut({
//         headers: headers,
//       })
//       // If successful, clear auth cookies on the response
//       res.clearCookie('session')
//       res.clearCookie('session.sig')
//       return res.status(200).json({
//         success: true,
//         message: 'Successfully signed out',
//       })
//     } catch (error) {
//       console.error('Sign out error:', error)
//       // Even if the backend signOut failed, clear cookies and return success
//       // This ensures the frontend can still "sign out" the user
//       res.clearCookie('session')
//       res.clearCookie('session.sig')
//       return res.status(200).json({
//         success: true,
//         message: 'User signed out locally (cookies cleared)',
//         warning: 'Backend session might still exist',
//       })
//     }
//   } catch (error) {
//     console.error('Sign out error (unexpected):', error)
//     return res.status(500).json({
//       success: false,
//       error: error instanceof Error ? error.message : 'Sign out failed',
//       details: 'Unexpected error during sign out',
//     })
//   }
// })
// // Direct getSession endpoint that works with the better-auth API
// router.get('/session', async (req: Request, res: Response) => {
//   try {
//     const cookieHeader = req.headers.cookie
//     if (!cookieHeader) {
//       return res.status(401).json({
//         success: false,
//         message: 'No session cookie found',
//         hasSession: false,
//       })
//     }
//     try {
//       // Create headers for better-auth from the express request
//       const headers = new Headers()
//       // Add the necessary headers from the request
//       if (cookieHeader) headers.append('cookie', cookieHeader)
//       if (req.headers.host) headers.append('host', req.headers.host.toString())
//       if (req.headers.origin) headers.append('origin', req.headers.origin.toString())
//       // Get session using headers object
//       const session = await auth.api.getSession({
//         headers,
//       })
//       return res.status(200).json({
//         success: true,
//         message: 'Session found',
//         user: session?.user || null,
//         hasSession: true,
//       })
//     } catch (error) {
//       console.log('GetSession error:', error)
//       return res.status(401).json({
//         success: false,
//         message: 'No valid session',
//         error: error instanceof Error ? error.message : 'Session not found',
//         hasSession: false,
//       })
//     }
//   } catch (error) {
//     console.error('GetSession error:', error)
//     return res.status(500).json({
//       success: false,
//       error: error instanceof Error ? error.message : 'Failed to check session',
//     })
//   }
// })
// // Session check endpoint for debugging auth issues
// router.get('/session-check', async (req: Request, res: Response) => {
//   try {
//     console.log('Session check request received')
//     console.log('Headers:', JSON.stringify(req.headers, null, 2))
//     // Get all cookies from the request
//     const cookieHeader = req.headers.cookie
//     // Create headers object for better-auth
//     const headers = new Headers()
//     // Add all the headers from the original request
//     if (cookieHeader) headers.append('cookie', cookieHeader)
//     if (req.headers.host) headers.append('host', req.headers.host.toString())
//     if (req.headers.origin) headers.append('origin', req.headers.origin.toString())
//     try {
//       // Try to get the session using the request object
//       const session = await auth.api.getSession({
//         headers,
//       })
//       return res.status(200).json({
//         success: true,
//         message: 'Session found',
//         session: session,
//         hasSession: true,
//       })
//     } catch (error) {
//       console.log('Session check failed:', error)
//       return res.status(200).json({
//         success: true,
//         message: 'No active session found',
//         error: error instanceof Error ? error.message : 'Session not found',
//         hasSession: false,
//         cookiesPresent: Boolean(cookieHeader),
//       })
//     }
//   } catch (error) {
//     console.error('Session check error:', error)
//     return res.status(500).json({
//       success: false,
//       error: error instanceof Error ? error.message : 'Failed to check session',
//     })
//   }
// })
// export default router
//# sourceMappingURL=auth.js.map