"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadAllZips = loadAllZips;
exports.getZip = getZip;
// zipRepo.ts
const pg_1 = require("pg");
const pool = new pg_1.Pool({ connectionString: process.env.DATABASE_URL });
const cache = new Map();
async function loadAllZips() {
    const { rows } = await pool.query('SELECT zip, latitude, longitude, city, state FROM zip_codes');
    rows.forEach((r) => cache.set(r.zip, r));
}
async function getZip(zip) {
    if (!/^\d{5}$/.test(zip))
        return undefined;
    const hit = cache.get(zip);
    if (hit)
        return hit;
    const { rows } = await pool.query('SELECT zip, latitude, longitude, city, state FROM zip_codes WHERE zip=$1', [zip]);
    const row = rows[0];
    if (row)
        cache.set(zip, row);
    return row;
}
//# sourceMappingURL=zipcode.repo.js.map