import { PrismaClient } from '@prisma/client';
// Use a single instance of PrismaClient throughout the app lifecycle
const globalForPrisma = globalThis;
if (!globalForPrisma.prisma) {
    globalForPrisma.prisma = new PrismaClient({
        log: process.env.NODE_ENV === 'development' ? ['query', 'error', 'warn'] : ['error'],
    });
}
export const prisma = globalForPrisma.prisma;
//# sourceMappingURL=prismaClient.js.map