"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.betterauth = void 0;
const better_auth_1 = require("better-auth");
const prisma_1 = require("better-auth/adapters/prisma");
const plugins_1 = require("better-auth/plugins");
const prismaClient_1 = require("./prismaClient");
exports.betterauth = (0, better_auth_1.betterAuth)({
    database: (0, prisma_1.prismaAdapter)(prismaClient_1.prisma, {
        provider: 'postgresql', // or "postgres"
    }),
    emailAndPassword: {
        enabled: true,
        requireEmailVerification: true,
    },
    //   socialProviders: {
    //     github: {
    //       clientId: process.env.GITHUB_CLIENT_ID as string,
    //       clientSecret: process.env.GITHUB_CLIENT_SECRET as string,
    //     },
    //     google: {
    //       clientId: process.env.GOOGLE_CLIENT_ID as string,
    //       clientSecret: process.env.GOOGLE_CLIENT_SECRET as string,
    //     },
    //     // Add more providers as needed
    //   },
    session: {
        expiresIn: 60 * 60 * 24 * 7, // 7 days
        updateAge: 60 * 60 * 24, // 1 day
    },
    user: {
        additionalFields: {
            // Add any additional user fields you need
            role: {
                type: 'string',
                defaultValue: 'user',
            },
            avatar: {
                type: 'string',
                required: false,
            },
            firstName: {
                type: 'string',
                required: false,
            },
            lastName: {
                type: 'string',
                required: false,
            },
        },
    },
    trustedOrigins: [process.env.FRONTEND_URL || 'http://localhost:5000', process.env.APP_URL || 'http://localhost:8000'],
    secret: process.env.BETTER_AUTH_SECRET,
    advanced: {
        generateId: () => crypto.randomUUID(), // Use built-in crypto for ID generation
        crossSubDomainCookies: {
            enabled: true, // Set to true if you need cross-subdomain support
        },
    },
    plugins: [
        (0, plugins_1.openAPI)({
            path: '/docs',
            stripBasePath: true, // Add this to ensure paths are correctly generated
        }),
        // Add plugins as needed
        // Example: twoFactor(), adminPlugin(), etc.
    ],
});
//# sourceMappingURL=betterauth.js.map